/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.CharValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class CharValueImpl
extends PrimitiveValueImpl
implements CharValue {
    private char value;

    CharValueImpl(VirtualMachine virtualMachine, char c) {
        super(virtualMachine);
        this.value = c;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CharValue) {
            return this.value == ((CharValue)object).value() && super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int compareTo(CharValue charValue) {
        char c = charValue.value();
        return this.value() - c;
    }

    public Type type() {
        return this.vm.theCharType();
    }

    public char value() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value != '\u0000';
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > '\u007f') {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    short checkedShortValue() throws InvalidTypeException {
        if (this.value > Short.MAX_VALUE) {
            throw new InvalidTypeException("Can't convert " + this.value + " to short");
        }
        return super.checkedShortValue();
    }

    byte typeValueKey() {
        return 67;
    }
}

