/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class PrintGCStat {
    private RuntimeMXBean rmbean;
    private MemoryMXBean mmbean;
    private List<MemoryPoolMXBean> pools;
    private List<GarbageCollectorMXBean> gcmbeans;

    public PrintGCStat(MBeanServerConnection mBeanServerConnection) throws IOException {
        PlatformManagedObject platformManagedObject;
        ObjectName objectName;
        ObjectName objectName2;
        block6: {
            this.rmbean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Runtime", RuntimeMXBean.class);
            this.mmbean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Memory", MemoryMXBean.class);
            objectName2 = null;
            objectName = null;
            try {
                objectName2 = new ObjectName("java.lang:type=MemoryPool,*");
                objectName = new ObjectName("java.lang:type=GarbageCollector,*");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        Set<ObjectName> set = mBeanServerConnection.queryNames(objectName2, null);
        if (set != null) {
            this.pools = new ArrayList<MemoryPoolMXBean>();
            for (ObjectName objectName3 : set) {
                platformManagedObject = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName3.getCanonicalName(), MemoryPoolMXBean.class);
                this.pools.add((MemoryPoolMXBean)platformManagedObject);
            }
        }
        if ((set = mBeanServerConnection.queryNames(objectName, null)) != null) {
            this.gcmbeans = new ArrayList<GarbageCollectorMXBean>();
            for (ObjectName objectName3 : set) {
                platformManagedObject = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, objectName3.getCanonicalName(), GarbageCollectorMXBean.class);
                this.gcmbeans.add((GarbageCollectorMXBean)platformManagedObject);
            }
        }
    }

    public PrintGCStat() {
        this.rmbean = ManagementFactory.getRuntimeMXBean();
        this.mmbean = ManagementFactory.getMemoryMXBean();
        this.pools = ManagementFactory.getMemoryPoolMXBeans();
        this.gcmbeans = ManagementFactory.getGarbageCollectorMXBeans();
    }

    public void printVerboseGc() {
        System.out.print("Uptime: " + this.formatMillis(this.rmbean.getUptime()));
        for (GarbageCollectorMXBean platformManagedObject : this.gcmbeans) {
            System.out.print(" [" + platformManagedObject.getName() + ": ");
            System.out.print("Count=" + platformManagedObject.getCollectionCount());
            System.out.print(" GCTime=" + this.formatMillis(platformManagedObject.getCollectionTime()));
            System.out.print("]");
        }
        System.out.println();
        for (MemoryPoolMXBean memoryPoolMXBean : this.pools) {
            System.out.print("  [" + memoryPoolMXBean.getName() + ":");
            MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
            System.out.print(" Used=" + this.formatBytes(memoryUsage.getUsed()));
            System.out.print(" Committed=" + this.formatBytes(memoryUsage.getCommitted()));
            System.out.println("]");
        }
    }

    private String formatMillis(long l) {
        return String.format("%.4fsec", (double)l / 1000.0);
    }

    private String formatBytes(long l) {
        long l2 = l;
        if (l > 0L) {
            l2 = l / 1024L;
        }
        return l2 + "K";
    }
}

