/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.JsseJce;
import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class RSASignature
extends SignatureSpi {
    private final Signature rawRsa = JsseJce.getSignature("NONEwithRSA");
    private MessageDigest md5;
    private MessageDigest sha;
    private boolean isReset = true;

    static Signature getInstance() throws NoSuchAlgorithmException {
        return JsseJce.getSignature("MD5andSHA1withRSA");
    }

    static Signature getInternalInstance() throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance("MD5andSHA1withRSA", "SunJSSE");
    }

    static void setHashes(Signature signature, MessageDigest messageDigest, MessageDigest messageDigest2) {
        signature.setParameter("hashes", new MessageDigest[]{messageDigest, messageDigest2});
    }

    private void reset() {
        if (!this.isReset) {
            this.md5.reset();
            this.sha.reset();
            this.isReset = true;
        }
    }

    private static void checkNull(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSASignature.checkNull(publicKey);
        this.reset();
        this.rawRsa.initVerify(publicKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSASignature.checkNull(privateKey);
        this.reset();
        this.rawRsa.initSign(privateKey, secureRandom);
    }

    private void initDigests() {
        if (this.md5 == null) {
            this.md5 = JsseJce.getMD5();
            this.sha = JsseJce.getSHA();
        }
    }

    protected void engineUpdate(byte by) {
        this.initDigests();
        this.isReset = false;
        this.md5.update(by);
        this.sha.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.initDigests();
        this.isReset = false;
        this.md5.update(byArray, n, n2);
        this.sha.update(byArray, n, n2);
    }

    private byte[] getDigest() throws SignatureException {
        try {
            this.initDigests();
            byte[] byArray = new byte[36];
            this.md5.digest(byArray, 0, 16);
            this.sha.digest(byArray, 16, 20);
            this.isReset = true;
            return byArray;
        }
        catch (DigestException digestException) {
            throw new SignatureException(digestException);
        }
    }

    protected byte[] engineSign() throws SignatureException {
        this.rawRsa.update(this.getDigest());
        return this.rawRsa.sign();
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        this.rawRsa.update(this.getDigest());
        return this.rawRsa.verify(byArray, n, n2);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        if (!string.equals("hashes")) {
            throw new InvalidParameterException("Parameter not supported: " + string);
        }
        if (!(object instanceof MessageDigest[])) {
            throw new InvalidParameterException("value must be MessageDigest[]");
        }
        MessageDigest[] messageDigestArray = (MessageDigest[])object;
        this.md5 = messageDigestArray[0];
        this.sha = messageDigestArray[1];
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameters not supported");
    }
}

