/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.util.ArrayList;
import java.util.List;
import sun.management.BooleanFlag;
import sun.management.Flag;
import sun.management.HotspotRuntimeMBean;
import sun.management.LongFlag;
import sun.management.ManagementFactory;
import sun.management.StringFlag;
import sun.management.VMManagement;

class HotspotRuntime
implements HotspotRuntimeMBean {
    private VMManagement jvm;
    private static final String JAVA_RT = "java.rt.";
    private static final String COM_SUN_RT = "com.sun.rt.";
    private static final String SUN_RT = "sun.rt.";
    private static final String JAVA_PROPERTY = "java.property.";
    private static final String COM_SUN_PROPERTY = "com.sun.property.";
    private static final String SUN_PROPERTY = "sun.property.";
    private static final String RT_COUNTER_NAME_PATTERN = "java.rt.|com.sun.rt.|sun.rt.|java.property.|com.sun.property.|sun.property.";

    HotspotRuntime(VMManagement vMManagement) {
        this.jvm = vMManagement;
    }

    public long getSafepointCount() {
        return this.jvm.getSafepointCount();
    }

    public long getTotalSafepointTime() {
        return this.jvm.getTotalSafepointTime();
    }

    public long getSafepointSyncTime() {
        return this.jvm.getSafepointSyncTime();
    }

    public List getInternalFlagNames() {
        ManagementFactory.checkMonitorAccess();
        String[] stringArray = this.getAllFlagNames();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public List getInternalFlags() {
        ManagementFactory.checkMonitorAccess();
        int n = this.getInternalFlagCount();
        Flag[] flagArray = new Flag[n];
        int n2 = this.getFlags(null, flagArray, n);
        ArrayList<Flag> arrayList = new ArrayList<Flag>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(flagArray[i]);
        }
        return arrayList;
    }

    private native int getFlags(String[] var1, Flag[] var2, int var3);

    private native String[] getAllFlagNames();

    private native int getInternalFlagCount();

    public Flag getFlag(String string) {
        ManagementFactory.checkMonitorAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        Flag[] flagArray = new Flag[1];
        String[] stringArray = new String[]{string};
        int n = this.getFlags(stringArray, flagArray, 1);
        if (n == 0) {
            return null;
        }
        return flagArray[0];
    }

    public LongFlag setLongFlag(String string, long l) {
        ManagementFactory.checkControlAccess();
        Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        if (!flag.isWriteable()) {
            throw new UnsupportedOperationException("Flag is not writeable");
        }
        if (flag instanceof LongFlag) {
            return null;
        }
        throw new IllegalArgumentException("Flag is not a LongFlag");
    }

    public BooleanFlag setBooleanFlag(String string, boolean bl) {
        ManagementFactory.checkControlAccess();
        Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        if (!flag.isWriteable()) {
            throw new UnsupportedOperationException("Flag is not writeable");
        }
        if (flag instanceof BooleanFlag) {
            return null;
        }
        throw new IllegalArgumentException("Flag is not a BooleanFlag");
    }

    public StringFlag setStringFlag(String string, String string2) {
        ManagementFactory.checkControlAccess();
        Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        if (!flag.isWriteable()) {
            throw new UnsupportedOperationException("Flag is not writeable");
        }
        if (flag instanceof StringFlag) {
            return null;
        }
        throw new IllegalArgumentException("Flag is not a StringFlag");
    }

    public List getInternalRuntimeCounters() {
        return this.jvm.getInternalCounters(RT_COUNTER_NAME_PATTERN);
    }

    private static native void initialize();

    static {
        HotspotRuntime.initialize();
    }
}

