/*
 * Decompiled with CFR 0.152.
 */
package sun.instrument;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import sun.instrument.TransformerManager;

public class InstrumentationImpl
implements Instrumentation {
    private final TransformerManager mTransformerManager = new TransformerManager();
    private final long mNativeAgent;
    private final boolean mEnvironmentSupportsRedefineClasses;

    private InstrumentationImpl(long l, boolean bl) {
        this.mNativeAgent = l;
        this.mEnvironmentSupportsRedefineClasses = bl;
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in addTransformer");
        }
        this.mTransformerManager.addTransformer(classFileTransformer);
    }

    public boolean removeTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in removeTransformer");
        }
        return this.mTransformerManager.removeTransformer(classFileTransformer);
    }

    public boolean isRedefineClassesSupported() {
        return this.mEnvironmentSupportsRedefineClasses;
    }

    public void redefineClasses(ClassDefinition[] classDefinitionArray) throws ClassNotFoundException {
        if (!this.isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("redefineClasses is not supported in this environment");
        }
        if (classDefinitionArray == null) {
            throw new NullPointerException("null passed as 'definitions' in redefineClasses");
        }
        for (int i = 0; i < classDefinitionArray.length; ++i) {
            if (classDefinitionArray[i] != null) continue;
            throw new NullPointerException("element of 'definitions' is null in redefineClasses");
        }
        if (classDefinitionArray.length == 0) {
            return;
        }
        this.redefineClasses0(classDefinitionArray);
    }

    public Class[] getAllLoadedClasses() {
        return this.getAllLoadedClasses0();
    }

    public Class[] getInitiatedClasses(ClassLoader classLoader) {
        return this.getInitiatedClasses0(classLoader);
    }

    public long getObjectSize(Object object) {
        if (object == null) {
            throw new NullPointerException("null passed as 'objectToSize' in getObjectSize");
        }
        return this.getObjectSize0(object);
    }

    private native void redefineClasses0(ClassDefinition[] var1) throws ClassNotFoundException;

    public native Class[] getAllLoadedClasses0();

    public native Class[] getInitiatedClasses0(ClassLoader var1);

    public native long getObjectSize0(Object var1);

    private long getNativeAgent() {
        return this.mNativeAgent;
    }

    private void loadClassAndCallPremain(String string, String string2) throws Throwable {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getMethod("premain", String.class, Instrumentation.class);
        method.invoke(null, string2, this);
    }

    private byte[] transform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        return this.mTransformerManager.transform(classLoader, string, clazz, protectionDomain, byArray);
    }
}

