/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WPanelPeer;

public class WWindowPeer
extends WPanelPeer
implements WindowPeer {
    private static final DebugHelper dbg = DebugHelper.create(WWindowPeer.class);
    protected boolean focusableWindow;
    static Vector allWindows;
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;

    private static native void initIDs();

    protected void disposeImpl() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).removeDisplayChangedListener(this);
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public void toFront() {
        this.updateFocusableWindowState();
        this._toFront();
    }

    native void _toFront();

    public native void toBack();

    public void updateAlwaysOnTop() {
        this.setAlwaysOnTop(((Window)this.target).isAlwaysOnTop());
    }

    native void setAlwaysOnTop(boolean var1);

    public void updateFocusableWindowState() {
        this.focusableWindow = ((Window)this.target).isFocusableWindow();
        this.setFocusableWindow(this.focusableWindow);
    }

    native void setFocusableWindow(boolean var1);

    public void setTitle(String string) {
        if (string == null) {
            string = new String("");
        }
        this._setTitle(string);
    }

    native void _setTitle(String var1);

    public void setResizable(boolean bl) {
        this._setResizable(bl);
    }

    public native void _setResizable(boolean var1);

    WWindowPeer(Window window) {
        super(window);
    }

    void initialize() {
        super.initialize();
        this.updateInsets(this.insets_);
        if (SunToolkit.isModalExcluded((Window)this.target)) {
            this.setModalExcluded();
        }
        allWindows.addElement(this);
        Font font = ((Window)this.target).getFont();
        if (font == null) {
            font = defaultFont;
            ((Window)this.target).setFont(font);
            this.setFont(font);
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).addDisplayChangedListener(this);
    }

    native void createAwtWindow(WComponentPeer var1);

    void create(WComponentPeer wComponentPeer) {
        this.createAwtWindow(wComponentPeer);
    }

    protected void realShow() {
        super.show();
    }

    public void show() {
        this.updateFocusableWindowState();
        this.realShow();
        if (((Window)this.target).isAlwaysOnTop()) {
            this.setAlwaysOnTop(true);
        }
        this.updateGC();
        this.resetTargetGC();
    }

    native void updateInsets(Insets var1);

    private native Component getContainerElement(Container var1, int var2);

    static native int getSysMinWidth();

    static native int getSysMinHeight();

    synchronized native void reshapeFrame(int var1, int var2, int var3, int var4);

    public boolean requestWindowFocus() {
        return false;
    }

    public void setModalExcluded() {
        this.setModalExcludedNativeProp();
    }

    protected native void setModalExcludedNativeProp();

    void draggedToNewScreen() {
        SunToolkit.executeOnEventHandlerThread((Component)this.target, new Runnable(){

            public void run() {
                WWindowPeer.this.displayChanged();
            }
        });
    }

    void clearLocalGC() {
    }

    public native void resetTargetGC();

    public void updateGC() {
        int n = this.getScreenImOn();
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.winGraphicsConfig.getDevice();
        Win32GraphicsDevice win32GraphicsDevice2 = (Win32GraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[n];
        this.winGraphicsConfig = (Win32GraphicsConfig)win32GraphicsDevice2.getDefaultConfiguration();
        if (win32GraphicsDevice != win32GraphicsDevice2) {
            win32GraphicsDevice.removeDisplayChangedListener(this);
            win32GraphicsDevice2.addDisplayChangedListener(this);
        }
    }

    public void displayChanged() {
        this.updateGC();
        super.displayChanged();
    }

    private native int getScreenImOn();

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n, n2, n3, n4);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        int n9 = rectangle.width - insets.left - insets.right;
        int n10 = rectangle.height - insets.top - insets.bottom;
        if (!((Window)this.target).isVisible() || this.isTargetUndecorated()) {
            int n11 = rectangle.x + insets.left;
            int n12 = rectangle.y + insets.top;
            if (n7 > n9) {
                n7 = n9;
            }
            if (n8 > n10) {
                n8 = n10;
            }
            if (n5 < n11) {
                n5 = n11;
            } else if (n5 + n7 > n11 + n9) {
                n5 = n11 + n9 - n7;
            }
            if (n6 < n12) {
                n6 = n12;
            } else if (n6 + n8 > n12 + n10) {
                n6 = n12 + n10 - n8;
            }
        } else {
            int n13 = Math.max(n9, this.sysW);
            int n14 = Math.max(n10, this.sysH);
            if (n7 > n13) {
                n7 = n13;
            }
            if (n8 > n14) {
                n8 = n14;
            }
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        this.sysX = rectangle.x;
        this.sysY = rectangle.y;
        this.sysW = rectangle.width;
        this.sysH = rectangle.height;
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5);
    }

    static {
        WWindowPeer.initIDs();
        allWindows = new Vector();
    }
}

