/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.utils.XMLCharacterRecognizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class FastStringBuffer {
    static final int DEBUG_FORCE_INIT_BITS = 0;
    static boolean DEBUG_FORCE_FIXED_CHUNKSIZE = true;
    public static final int SUPPRESS_LEADING_WS = 1;
    public static final int SUPPRESS_TRAILING_WS = 2;
    public static final int SUPPRESS_BOTH = 3;
    private static final int CARRY_WS = 4;
    int m_chunkBits = 15;
    int m_maxChunkBits = 15;
    int m_rebundleBits = 2;
    int m_chunkSize;
    int m_chunkMask;
    char[][] m_array;
    int m_lastChunk = 0;
    int m_firstFree = 0;
    FastStringBuffer m_innerFSB = null;
    static final char[] SINGLE_SPACE = new char[]{' '};

    public FastStringBuffer(int n, int n2, int n3) {
        if (DEBUG_FORCE_FIXED_CHUNKSIZE) {
            n2 = n;
        }
        this.m_array = new char[16][];
        if (n > n2) {
            n = n2;
        }
        this.m_chunkBits = n;
        this.m_maxChunkBits = n2;
        this.m_rebundleBits = n3;
        this.m_chunkSize = 1 << n;
        this.m_chunkMask = this.m_chunkSize - 1;
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public FastStringBuffer(int n, int n2) {
        this(n, n2, 2);
    }

    public FastStringBuffer(int n) {
        this(n, 15, 2);
    }

    public FastStringBuffer() {
        this(10, 15, 2);
    }

    public final int size() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final int length() {
        return (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
    }

    public final void reset() {
        this.m_lastChunk = 0;
        this.m_firstFree = 0;
        FastStringBuffer fastStringBuffer = this;
        while (fastStringBuffer.m_innerFSB != null) {
            fastStringBuffer = fastStringBuffer.m_innerFSB;
        }
        this.m_chunkBits = fastStringBuffer.m_chunkBits;
        this.m_chunkSize = fastStringBuffer.m_chunkSize;
        this.m_chunkMask = fastStringBuffer.m_chunkMask;
        this.m_innerFSB = null;
        this.m_array = new char[16][0];
        this.m_array[0] = new char[this.m_chunkSize];
    }

    public final void setLength(int n) {
        this.m_lastChunk = n >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(n, this);
        } else {
            this.m_firstFree = n & this.m_chunkMask;
            if (this.m_firstFree == 0 && this.m_lastChunk > 0) {
                --this.m_lastChunk;
                this.m_firstFree = this.m_chunkSize;
            }
        }
    }

    private final void setLength(int n, FastStringBuffer fastStringBuffer) {
        this.m_lastChunk = n >>> this.m_chunkBits;
        if (this.m_lastChunk == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.setLength(n, fastStringBuffer);
        } else {
            fastStringBuffer.m_chunkBits = this.m_chunkBits;
            fastStringBuffer.m_maxChunkBits = this.m_maxChunkBits;
            fastStringBuffer.m_rebundleBits = this.m_rebundleBits;
            fastStringBuffer.m_chunkSize = this.m_chunkSize;
            fastStringBuffer.m_chunkMask = this.m_chunkMask;
            fastStringBuffer.m_array = this.m_array;
            fastStringBuffer.m_innerFSB = this.m_innerFSB;
            fastStringBuffer.m_lastChunk = this.m_lastChunk;
            fastStringBuffer.m_firstFree = n & this.m_chunkMask;
        }
    }

    public final String toString() {
        int n = (this.m_lastChunk << this.m_chunkBits) + this.m_firstFree;
        return this.getString(new StringBuffer(n), 0, 0, n).toString();
    }

    public final void append(char c) {
        char[] cArray;
        boolean bl;
        boolean bl2 = bl = this.m_lastChunk + 1 == this.m_array.length;
        if (this.m_firstFree < this.m_chunkSize) {
            cArray = this.m_array[this.m_lastChunk];
        } else {
            int n = this.m_array.length;
            if (this.m_lastChunk + 1 == n) {
                char[][] cArrayArray = new char[n + 16][];
                System.arraycopy(this.m_array, 0, cArrayArray, 0, n);
                this.m_array = cArrayArray;
            }
            if ((cArray = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                cArray = this.m_array[this.m_lastChunk];
            }
            this.m_firstFree = 0;
        }
        cArray[this.m_firstFree++] = c;
    }

    public final void append(String string) {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (0 == n) {
            return;
        }
        int n2 = 0;
        char[] cArray = this.m_array[this.m_lastChunk];
        int n3 = this.m_chunkSize - this.m_firstFree;
        while (n > 0) {
            if (n3 > n) {
                n3 = n;
            }
            string.getChars(n2, n2 + n3, this.m_array[this.m_lastChunk], this.m_firstFree);
            n2 += n3;
            if ((n -= n3) <= 0) continue;
            int n4 = this.m_array.length;
            if (this.m_lastChunk + 1 == n4) {
                char[][] cArrayArray = new char[n4 + 16][];
                System.arraycopy(this.m_array, 0, cArrayArray, 0, n4);
                this.m_array = cArrayArray;
            }
            if ((cArray = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                cArray = this.m_array[this.m_lastChunk];
            }
            n3 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += n3;
    }

    public final void append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return;
        }
        int n = stringBuffer.length();
        if (0 == n) {
            return;
        }
        int n2 = 0;
        char[] cArray = this.m_array[this.m_lastChunk];
        int n3 = this.m_chunkSize - this.m_firstFree;
        while (n > 0) {
            if (n3 > n) {
                n3 = n;
            }
            stringBuffer.getChars(n2, n2 + n3, this.m_array[this.m_lastChunk], this.m_firstFree);
            n2 += n3;
            if ((n -= n3) <= 0) continue;
            int n4 = this.m_array.length;
            if (this.m_lastChunk + 1 == n4) {
                char[][] cArrayArray = new char[n4 + 16][];
                System.arraycopy(this.m_array, 0, cArrayArray, 0, n4);
                this.m_array = cArrayArray;
            }
            if ((cArray = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                cArray = this.m_array[this.m_lastChunk];
            }
            n3 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += n3;
    }

    public final void append(char[] cArray, int n, int n2) {
        int n3 = n2;
        if (0 == n3) {
            return;
        }
        int n4 = n;
        char[] cArray2 = this.m_array[this.m_lastChunk];
        int n5 = this.m_chunkSize - this.m_firstFree;
        while (n3 > 0) {
            if (n5 > n3) {
                n5 = n3;
            }
            System.arraycopy(cArray, n4, this.m_array[this.m_lastChunk], this.m_firstFree, n5);
            n4 += n5;
            if ((n3 -= n5) <= 0) continue;
            int n6 = this.m_array.length;
            if (this.m_lastChunk + 1 == n6) {
                char[][] cArrayArray = new char[n6 + 16][];
                System.arraycopy(this.m_array, 0, cArrayArray, 0, n6);
                this.m_array = cArrayArray;
            }
            if ((cArray2 = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                cArray2 = this.m_array[this.m_lastChunk];
            }
            n5 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += n5;
    }

    public final void append(FastStringBuffer fastStringBuffer) {
        if (fastStringBuffer == null) {
            return;
        }
        int n = fastStringBuffer.length();
        if (0 == n) {
            return;
        }
        int n2 = 0;
        char[] cArray = this.m_array[this.m_lastChunk];
        int n3 = this.m_chunkSize - this.m_firstFree;
        while (n > 0) {
            if (n3 > n) {
                n3 = n;
            }
            int n4 = n2 + fastStringBuffer.m_chunkSize - 1 >>> fastStringBuffer.m_chunkBits;
            int n5 = n2 & fastStringBuffer.m_chunkMask;
            int n6 = fastStringBuffer.m_chunkSize - n5;
            if (n6 > n3) {
                n6 = n3;
            }
            System.arraycopy(fastStringBuffer.m_array[n4], n5, this.m_array[this.m_lastChunk], this.m_firstFree, n6);
            if (n6 != n3) {
                System.arraycopy(fastStringBuffer.m_array[n4 + 1], 0, this.m_array[this.m_lastChunk], this.m_firstFree + n6, n3 - n6);
            }
            n2 += n3;
            if ((n -= n3) <= 0) continue;
            int n7 = this.m_array.length;
            if (this.m_lastChunk + 1 == n7) {
                char[][] cArrayArray = new char[n7 + 16][];
                System.arraycopy(this.m_array, 0, cArrayArray, 0, n7);
                this.m_array = cArrayArray;
            }
            if ((cArray = this.m_array[++this.m_lastChunk]) == null) {
                if (this.m_lastChunk == 1 << this.m_rebundleBits && this.m_chunkBits < this.m_maxChunkBits) {
                    this.m_innerFSB = new FastStringBuffer(this);
                }
                this.m_array[this.m_lastChunk] = new char[this.m_chunkSize];
                cArray = this.m_array[this.m_lastChunk];
            }
            n3 = this.m_chunkSize;
            this.m_firstFree = 0;
        }
        this.m_firstFree += n3;
    }

    public boolean isWhitespace(int n, int n2) {
        int n3 = n >>> this.m_chunkBits;
        int n4 = n & this.m_chunkMask;
        int n5 = this.m_chunkSize - n4;
        while (n2 > 0) {
            int n6 = n2 <= n5 ? n2 : n5;
            boolean bl = n3 == 0 && this.m_innerFSB != null ? this.m_innerFSB.isWhitespace(n4, n6) : XMLCharacterRecognizer.isWhiteSpace(this.m_array[n3], n4, n6);
            if (!bl) {
                return false;
            }
            n2 -= n6;
            ++n3;
            n4 = 0;
            n5 = this.m_chunkSize;
        }
        return true;
    }

    public String getString(int n, int n2) {
        int n3 = n & this.m_chunkMask;
        int n4 = n >>> this.m_chunkBits;
        if (n3 + n2 < this.m_chunkMask && this.m_innerFSB == null) {
            return this.getOneChunkString(n4, n3, n2);
        }
        return this.getString(new StringBuffer(n2), n4, n3, n2).toString();
    }

    protected String getOneChunkString(int n, int n2, int n3) {
        return new String(this.m_array[n], n2, n3);
    }

    StringBuffer getString(StringBuffer stringBuffer, int n, int n2) {
        return this.getString(stringBuffer, n >>> this.m_chunkBits, n & this.m_chunkMask, n2);
    }

    StringBuffer getString(StringBuffer stringBuffer, int n, int n2, int n3) {
        int n4 = (n << this.m_chunkBits) + n2 + n3;
        int n5 = n4 >>> this.m_chunkBits;
        int n6 = n4 & this.m_chunkMask;
        for (int i = n; i < n5; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.getString(stringBuffer, n2, this.m_chunkSize - n2);
            } else {
                stringBuffer.append(this.m_array[i], n2, this.m_chunkSize - n2);
            }
            n2 = 0;
        }
        if (n5 == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.getString(stringBuffer, n2, n6 - n2);
        } else if (n6 > n2) {
            stringBuffer.append(this.m_array[n5], n2, n6 - n2);
        }
        return stringBuffer;
    }

    public char charAt(int n) {
        int n2 = n >>> this.m_chunkBits;
        if (n2 == 0 && this.m_innerFSB != null) {
            return this.m_innerFSB.charAt(n & this.m_chunkMask);
        }
        return this.m_array[n2][n & this.m_chunkMask];
    }

    public void sendSAXcharacters(ContentHandler contentHandler, int n, int n2) throws SAXException {
        int n3 = n >>> this.m_chunkBits;
        int n4 = n & this.m_chunkMask;
        if (n4 + n2 < this.m_chunkMask && this.m_innerFSB == null) {
            contentHandler.characters(this.m_array[n3], n4, n2);
            return;
        }
        int n5 = n + n2;
        int n6 = n5 >>> this.m_chunkBits;
        int n7 = n5 & this.m_chunkMask;
        for (int i = n3; i < n6; ++i) {
            if (i == 0 && this.m_innerFSB != null) {
                this.m_innerFSB.sendSAXcharacters(contentHandler, n4, this.m_chunkSize - n4);
            } else {
                contentHandler.characters(this.m_array[i], n4, this.m_chunkSize - n4);
            }
            n4 = 0;
        }
        if (n6 == 0 && this.m_innerFSB != null) {
            this.m_innerFSB.sendSAXcharacters(contentHandler, n4, n7 - n4);
        } else if (n7 > n4) {
            contentHandler.characters(this.m_array[n6], n4, n7 - n4);
        }
    }

    public int sendNormalizedSAXcharacters(ContentHandler contentHandler, int n, int n2) throws SAXException {
        int n3 = 1;
        int n4 = n + n2;
        int n5 = n >>> this.m_chunkBits;
        int n6 = n & this.m_chunkMask;
        int n7 = n4 >>> this.m_chunkBits;
        int n8 = n4 & this.m_chunkMask;
        for (int i = n5; i < n7; ++i) {
            n3 = i == 0 && this.m_innerFSB != null ? this.m_innerFSB.sendNormalizedSAXcharacters(contentHandler, n6, this.m_chunkSize - n6) : FastStringBuffer.sendNormalizedSAXcharacters(this.m_array[i], n6, this.m_chunkSize - n6, contentHandler, n3);
            n6 = 0;
        }
        if (n7 == 0 && this.m_innerFSB != null) {
            n3 = this.m_innerFSB.sendNormalizedSAXcharacters(contentHandler, n6, n8 - n6);
        } else if (n8 > n6) {
            n3 = FastStringBuffer.sendNormalizedSAXcharacters(this.m_array[n7], n6, n8 - n6, contentHandler, n3 | 2);
        }
        return n3;
    }

    static int sendNormalizedSAXcharacters(char[] cArray, int n, int n2, ContentHandler contentHandler, int n3) throws SAXException {
        int n4;
        boolean bl = (n3 & 1) != 0;
        boolean bl2 = (n3 & 4) != 0;
        boolean bl3 = (n3 & 2) != 0;
        int n5 = n + n2;
        if (bl) {
            for (n4 = n; n4 < n5 && XMLCharacterRecognizer.isWhiteSpace(cArray[n4]); ++n4) {
            }
            if (n4 == n5) {
                return n3;
            }
        }
        while (n4 < n5) {
            int n6 = n4;
            while (n4 < n5 && !XMLCharacterRecognizer.isWhiteSpace(cArray[n4])) {
                ++n4;
            }
            if (n6 != n4) {
                if (bl2) {
                    contentHandler.characters(SINGLE_SPACE, 0, 1);
                    bl2 = false;
                }
                contentHandler.characters(cArray, n6, n4 - n6);
            }
            int n7 = n4;
            while (n4 < n5 && XMLCharacterRecognizer.isWhiteSpace(cArray[n4])) {
                ++n4;
            }
            if (n7 == n4) continue;
            bl2 = true;
        }
        return (bl2 ? 4 : 0) | n3 & 2;
    }

    public static void sendNormalizedSAXcharacters(char[] cArray, int n, int n2, ContentHandler contentHandler) throws SAXException {
        FastStringBuffer.sendNormalizedSAXcharacters(cArray, n, n2, contentHandler, 3);
    }

    public void sendSAXComment(LexicalHandler lexicalHandler, int n, int n2) throws SAXException {
        String string = this.getString(n, n2);
        lexicalHandler.comment(string.toCharArray(), 0, n2);
    }

    private void getChars(int n, int n2, char[] cArray, int n3) {
    }

    private FastStringBuffer(FastStringBuffer fastStringBuffer) {
        this.m_chunkBits = fastStringBuffer.m_chunkBits;
        this.m_maxChunkBits = fastStringBuffer.m_maxChunkBits;
        this.m_rebundleBits = fastStringBuffer.m_rebundleBits;
        this.m_chunkSize = fastStringBuffer.m_chunkSize;
        this.m_chunkMask = fastStringBuffer.m_chunkMask;
        this.m_array = fastStringBuffer.m_array;
        this.m_innerFSB = fastStringBuffer.m_innerFSB;
        this.m_lastChunk = fastStringBuffer.m_lastChunk - 1;
        this.m_firstFree = fastStringBuffer.m_chunkSize;
        fastStringBuffer.m_array = new char[16][];
        fastStringBuffer.m_innerFSB = this;
        fastStringBuffer.m_lastChunk = 1;
        fastStringBuffer.m_firstFree = 0;
        fastStringBuffer.m_chunkBits += this.m_rebundleBits;
        fastStringBuffer.m_chunkSize = 1 << fastStringBuffer.m_chunkBits;
        fastStringBuffer.m_chunkMask = fastStringBuffer.m_chunkSize - 1;
    }
}

